% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

function MouseDraw

%% Display Setup Module

% Define display parameters

whichScreen = max(Screen('screens'));
p.ScreenDistance = 30; 	% in inches
p.ScreenHeight = 15; 	% in inches
p.ScreenGamma = 2;	% from monitor calibration
p.maxLuminance = 100; % from monitor calibration
p.ScreenBackground = 0.5;

% Open the display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');  % setup Gamma correction method
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);  % open a display window
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);  % set Gamma for all color channels
% HideCursor;

% Get frame rate and set screen font

p.ScreenFrameRate = FrameRate(windowPtr);
Screen('TextFont', windowPtr, 'Times'); 
Screen('TextSize', windowPtr, 24);

%% Experimental Module

lineWidth = 1; % pixels
% Set the cursor to its initial location
SetMouse(100, 100);
str = 'Press on the left mouse button and move it to draw. Release to finish';
Screen('DrawText', windowPtr, str, 50, 50, 1);
Screen('Flip', windowPtr);
% Wait for click and hide the cursor
while 1
    [x0, y0, buttons] = GetMouse(windowPtr);
    if buttons(1), break; end
end
HideCursor;
thePoints = nan(10000,2);   % pre-allocate record of mouse 
                            % locations
thePoints(1, :) = [x0 y0];  % first point
i = 2;
while 1
    [x, y, buttons] = GetMouse(windowPtr);
    if ~buttons(1), break;  end 
                            % exit when button is released
    if (x ~= x0 || y ~= y0) % make sure mouse is moving
        Screen('DrawLine', windowPtr, 128, x0, y0, x, y, ...
               lineWidth);
        Screen('Flip', windowPtr, 0, 1); % update the drawing 
                                         % on the display
        thePoints(i, :) = [x y];
        x0 = x;
        y0 = y;
        i = i + 1;
    end
end

% Plot the contour in a Matlab figure
thePoints(i : end, :) = [];
figure(7);
plot(thePoints(:, 1), p.ScreenRect(4) - thePoints(:, 2), ...
    'linewidth', lineWidth);
axis equal;
xlim(p.ScreenRect([1 3]));
ylim(p.ScreenRect([2 4]));

%% System Reinstatement Module

Priority(0);  % restore priority
sca; % close window and textures, restore color lookup table
